import pile

class Labyrinthe:
    def __init__(self, tab):
        self.tab = tab # tableau représentant le labyrinthe
        self.pile = pile.Pile()
        
    def nb_lignes(self):
        ''' Renvoie le nombre de lignes du labyrinthe '''
        return len(self.tab)
    
    def nb_colonnes(self):
        ''' Renvoie le nombre de colonnes du labyrinthe '''
        return len(self.tab[0])
    
    def depart(self):
        ''' Renvoie les coordonées de la case de départ '''
        for i in range(self.nb_lignes()):
            for j in range(self.nb_colonnes()):
                if self.tab[i][j] == 2:
                    return (i, j)
    
    def arrivee(self):
        ''' Renvoie les coordonées de la case d'arrivée '''
        for i in range(self.nb_lignes()):
            for j in range(self.nb_colonnes()):
                if self.tab[i][j] == 3:
                    return (i, j)
    
    def est_valide(self, i, j):
        ''' Renvoie si il est possible ou non de se deplacer sur cette case '''
        return i < self.nb_lignes() and i >= 0 and j >= 0 and j < self.nb_colonnes()
    
    def nb_cases_vides(self):
        ''' Renvoie le nombre de cases où il est possible d'aller '''
        counter = 0
        for l in self.tab:
            for c in l:
                if c != 1:
                    counter += 1
        return counter
    
    def est_visite(self, i, j):
        ''' Renvoie si la case a été visitée par l'IA ou non '''
        if self.valide(i, j):
            self.tab[i][j] = 4
    
    def liste_voisines_libres(self, i, j):
        ''' Renvoie la liste des cases où l'IA peut aller '''
        if not(self.est_valide(i, j)):
            return []
        tmp_tab = []
        if self.est_valide(i-1, j) and self.tab[i-1][j] != 1 and self.tab[i-1][j] != 4:
            tmp_tab.append((i-1, j))
        if self.est_valide(i, j+1) and self.tab[i][j+1] != 1 and self.tab[i][j+1] != 4:
            tmp_tab.append((i, j+1))
        if self.est_valide(i+1, j) and self.tab[i+1][j] != 1 and self.tab[i+1][j] != 4:
            tmp_tab.append((i+1, j))
        if self.est_valide(i, j-1) and self.tab[i][j-1] != 1 and self.tab[i][j-1] != 4:
            tmp_tab.append((i, j-1))
        return tmp_tab
    
    def parcours(self, i, j, lab_copie):
        ''' Renvoie une pile contenant les coordonnées de chaque case du chemin de la solution '''
        if lab_copie.tab[i][j] == 3:
            self.pile.empiler((i,j))
            return self.pile
        
        lab_copie.tab[i][j] = 4
        voisins = lab_copie.liste_voisines_libres(i,j)
        
        if voisins == []:
            n1, n2 = self.pile.depiler()
        else:
            self.pile.empiler((i,j))
            n1, n2 = voisins[0]
        
        return self.parcours(n1, n2, lab_copie)
